# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/tools/data_validation.py
from pydantic import ValidationError
from data_extraction_system.models.extraction_schema import MortgageData

def is_valid_data(data: dict) -> bool:
    """Validates the extracted data against the MortgageData schema."""
    try:
        MortgageData(**data)
        return True
    except ValidationError as e:
        print(f"Data validation failed: {e}")
        return False
