# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/tests/test_ocr_engine.py
import unittest
from unittest.mock import patch
from data_extraction_system.tools.ocr_engine import perform_ocr

class TestOCREngine(unittest.TestCase):

    @patch("data_extraction_system.tools.ocr_engine.documentai.DocumentProcessorServiceClient")
    def test_perform_ocr(self, mock_documentai_client):
        """Tests the perform_ocr function using mock Google Cloud Document AI client."""
        # Mock the Document AI client and its methods
        mock_client_instance = MagicMock()
        mock_documentai_client.return_value = mock_client_instance

        mock_processor_path = "projects/test-project/locations/us-central1/processors/test-processor"
        mock_client_instance.processor_path.return_value = mock_processor_path

        mock_document = MagicMock()
        mock_document.text = "This is mocked OCR text from a document."
        mock_result = MagicMock()
        mock_result.document = mock_document
        mock_client_instance.process_document.return_value = mock_result

        # Mock environment variables
        with patch.dict(os.environ, {
            "GOOGLE_CLOUD_PROJECT_ID": "test-project",
            "DOCUMENT_AI_LOCATION": "us-central1",
            "DOCUMENT_AI_PROCESSOR_ID": "test-processor"
        }):
            # Call the function with a dummy document path
            extracted_text = perform_ocr("dummy/path/to/document.pdf")

            # Assertions
            self.assertIsInstance(extracted_text, str)
            self.assertIn("mocked OCR text", extracted_text)
            mock_client_instance.processor_path.assert_called_once_with("test-project", "us-central1", "test-processor")
            mock_client_instance.process_document.assert_called_once()

if __name__ == "__main__":
    unittest.main()
