# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/tests/test_document_processor_agent.py
import unittest
from unittest.mock import patch, MagicMock
from google.adk.runners import InMemoryRunner
from data_extraction_system.agents.document_processor_agent import document_processor_agent

class TestDocumentProcessorAgent(unittest.TestCase):

    @patch("google.adk.runners.InMemoryRunner.run_async")
    def test_agent_flow(self, mock_run_async):
        """Tests the document processor agent flow."""
        # Mock the async iterator returned by run_async
        mock_event = MagicMock()
        mock_event.author = "TestAgent"
        mock_event.content.parts[0].text = "Processing complete."
        mock_run_async.return_value = [mock_event]

        runner = InMemoryRunner(agent=document_processor_agent, app_name="TestApp")
        
        # Simulate the main function call
        async def run_main():
            await runner.run_async(user_id="testuser", session_id="testsession", new_message="Process document")
        
        # Run the async test function
        asyncio.run(run_main())

        # Assert that run_async was called with the correct parameters
        mock_run_async.assert_called_once()
        call_args, _ = mock_run_async.call_args
        self.assertEqual(call_args[0]['user_id'], "testuser")
        self.assertEqual(call_args[0]['session_id'], "testsession")
        self.assertEqual(call_args[0]['new_message'], "Process document")

if __name__ == "__main__":
    unittest.main()
