# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/tests/test_data_validation.py
import unittest
from data_extraction_system.tools.data_validation import is_valid_data

class TestDataValidation(unittest.TestCase):

    def test_is_valid_data_valid(self):
        """Tests that is_valid_data returns True for valid data."""
        valid_data = {
            "borrower_name": "Test User",
            "loan_amount": 100000.0,
            "property_address": "123 Main St"
        }
        self.assertTrue(is_valid_data(valid_data))

    def test_is_valid_data_invalid(self):
        """Tests that is_valid_data returns False for invalid data (missing required field)."""
        invalid_data = {
            "loan_amount": 100000.0,
            "property_address": "123 Main St"
        }
        self.assertFalse(is_valid_data(invalid_data))

    def test_is_valid_data_invalid_type(self):
        """Tests that is_valid_data returns False for invalid data types."""
        invalid_data = {
            "borrower_name": "Test User",
            "loan_amount": "not a number", # Invalid type
            "property_address": "123 Main St"
        }
        self.assertFalse(is_valid_data(invalid_data))

if __name__ == "__main__":
    unittest.main()
