# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/tests/test_data_extractor_agent.py
import unittest
from unittest.mock import patch, MagicMock
from google.adk.runners import InMemoryRunner
from data_extraction_system.agents.data_extractor_agent import data_extractor_agent, ExtractionResult

class TestDataExtractorAgent(unittest.TestCase):

    @patch("data_extraction_system.agents.data_extractor_agent.extract_data")
    @patch("google.adk.runners.InMemoryRunner.run_async")
    def test_agent_extracts_data(self, mock_run_async, mock_extract_data):
        """Tests that the data extractor agent extracts data."""
        # Mock the return value of the actual extract_data function
        mock_extracted_data = {"borrower_name": "Jane Smith", "loan_amount": 750000.0, "property_address": "456 Oak Ave"}
        mock_extract_data.return_value = ExtractionResult(extracted_data=mock_extracted_data)

        # Mock the async iterator returned by run_async
        mock_event = MagicMock()
        mock_event.author = "DataExtractorAgent"
        mock_event.content.parts[0].text = "Data extracted successfully."
        mock_run_async.return_value = [mock_event]

        runner = InMemoryRunner(agent=data_extractor_agent, app_name="TestApp")

        async def run_main():
            await runner.run_async(user_id="testuser", session_id="testsession", new_message="Extract data from chunk")

        asyncio.run(run_main())

        # Assert that extract_data was called
        mock_extract_data.assert_called_once()
        # Assert that run_async was called
        mock_run_async.assert_called_once()

if __name__ == "__main__":
    unittest.main()
