# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/deployment/test_deployment.py
import unittest
import os
from unittest.mock import patch

# Mocking the google.cloud.aiplatform module to avoid actual deployment during tests
@patch("google.cloud.aiplatform.init")
@patch("google.cloud.aiplatform.Model")
class TestDeployment(unittest.TestCase):

    def setUp(self):
        # Set dummy environment variables for testing
        os.environ["GOOGLE_CLOUD_PROJECT_ID"] = "test-project"
        os.environ["VERTEX_AI_LOCATION"] = "us-central1"

    def tearDown(self):
        # Clean up environment variables
        del os.environ["GOOGLE_CLOUD_PROJECT_ID"]
        del os.environ["VERTEX_AI_LOCATION"]

    def test_deploy_script_runs(self, mock_model, mock_init):
        """Tests that the deploy script runs without errors and calls necessary functions."""
        from data_extraction_system.deployment.deploy import deploy_model

        # Mock the deploy method of the Model object
        mock_model_instance = mock_model.return_value
        mock_model_instance.deploy.return_value = "mock_endpoint_resource_name"

        try:
            deploy_model()
            mock_init.assert_called_once_with(project="test-project", location="us-central1")
            # Assert that Model was instantiated (this implies a model resource name was provided)
            # In a real scenario, you'd assert with the actual model resource name.
            mock_model.assert_called_once()
            mock_model_instance.deploy.assert_called_once()
            print("Deployment script ran successfully (mocked).")
        except Exception as e:
            self.fail(f"Deployment script failed with error: {e}")

if __name__ == "__main__":
    unittest.main()
