# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/agents/document_processor_agent.py
from google.adk.agents import LlmAgent
from google.adk.models import Gemini
from data_extraction_system.agents.data_extractor_agent import data_extractor_agent
from data_extraction_system.agents.validation_agent import validation_agent
from google.adk.tools import FunctionTool
from data_extraction_system.tools.document_splitter import split_document

document_processor_agent = LlmAgent(
    name="DocumentProcessorAgent",
    description="Orchestrates the data extraction process from mortgage documents.",
    model=Gemini(model="gemini-2.5-flash-lite"),
    instruction="You are responsible for processing mortgage documents. First, split the document into smaller chunks. Then, delegate the extraction to the DataExtractorAgent, and finally, validate the extracted data using the ValidationAgent.",
    tools=[
        FunctionTool(func=split_document),
        data_extractor_agent,
        validation_agent
    ]
)
