# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from langchain_core.prompts import ChatPromptTemplate
from langchain_core.runnables import RunnablePassthrough
from langchain_google_genai import ChatGoogleGenerativeAI
from mailing_list_engagement.tools.google_analytics_api import GoogleAnalyticsAPI

class ReportingAgent:
    def __init__(self, llm: ChatGoogleGenerativeAI, analytics_tool: GoogleAnalyticsAPI):
        self.llm = llm
        self.analytics_tool = analytics_tool
        self.prompt = ChatPromptTemplate.from_messages([
            ("system", "You are an expert report generator. You synthesize campaign goals and engagement metrics into a clear and concise report."),
            ("user", "Generate a campaign report based on the following information:\nCampaign Goal: {campaign_goal}\nEngagement Metrics: {engagement_metrics}\n\nProvide a summary of the campaign's performance against its goal.")
        ])

    def generate_report(self, campaign_goal: str, engagement_metrics: dict) -> str:
        chain = self.prompt | self.llm
        response = chain.invoke({
            "campaign_goal": campaign_goal,
            "engagement_metrics": engagement_metrics
        })
        return response.content
