# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from langchain_core.prompts import ChatPromptTemplate
from langchain_core.runnables import RunnablePassthrough
from langchain_google_genai import ChatGoogleGenerativeAI

class ListManagementAgent:
    def __init__(self, llm: ChatGoogleGenerativeAI):
        self.llm = llm
        self.prompt = ChatPromptTemplate.from_messages([
            ("system", "You are an expert in mailing list management. You can segment lists, identify inactive subscribers, and suggest list hygiene strategies."),
            ("user", "Based on the provided context, perform the requested list management task: {task_description}\nContext: {context}")
        ])

    def manage_list(self, task_description: str, context: str = "") -> str:
        chain = self.prompt | self.llm
        response = chain.invoke({
            "task_description": task_description,
            "context": context
        })
        return response.content
