# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from langchain_core.prompts import ChatPromptTemplate
from langchain_core.runnables import RunnablePassthrough
from langchain_google_genai import ChatGoogleGenerativeAI
from mailing_list_engagement.tools.google_analytics_api import GoogleAnalyticsAPI

class EngagementAnalysisAgent:
    def __init__(self, llm: ChatGoogleGenerativeAI, analytics_tool: GoogleAnalyticsAPI):
        self.llm = llm
        self.analytics_tool = analytics_tool
        self.prompt = ChatPromptTemplate.from_messages([
            ("system", "You are an expert in analyzing marketing campaign performance. Use the provided data to identify key trends and insights."),
            ("user", "Analyze the following engagement metrics for campaign '{campaign_id}':\n{metrics_data}\n\nProvide a summary of the performance, highlighting successes and areas for improvement.")
        ])

    def analyze_engagement(self, campaign_id: str) -> dict:
        # Fetch data from Google Analytics
        # In a real scenario, you would map campaign_id to specific GA filters/queries
        metrics = self.analytics_tool.get_campaign_metrics(campaign_id=campaign_id)
        return metrics

    def summarize_analysis(self, campaign_id: str, metrics_data: dict) -> str:
        chain = self.prompt | self.llm
        response = chain.invoke({
            "campaign_id": campaign_id,
            "metrics_data": metrics_data
        })
        return response.content
