# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from langchain_core.prompts import ChatPromptTemplate
from langchain_core.runnables import RunnablePassthrough
from langchain_google_genai import ChatGoogleGenerativeAI

class ContentCreationAgent:
    def __init__(self, llm: ChatGoogleGenerativeAI):
        self.llm = llm
        self.prompt = ChatPromptTemplate.from_messages([
            ("system", "You are an expert email copywriter. Your goal is to create compelling and engaging email content."),
            ("user", "Create email content for the following campaign goal: {campaign_goal}\nTarget audience: {target_audience}\n\nProvide the subject line and the email body.")
        ])

    def create_content(self, campaign_goal: str, target_audience: str) -> str:
        chain = self.prompt | self.llm
        response = chain.invoke({
            "campaign_goal": campaign_goal,
            "target_audience": target_audience
        })
        return response.content
