# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# deployment/test_deployment.py
import unittest
from unittest.mock import patch, MagicMock
import deployment.deploy

class TestDeployment(unittest.TestCase):

    @patch('deployment.deploy.aiplatform.init')
    def test_deploy_agent_initialization(self, mock_aiplatform_init):
        """Tests if aiplatform.init is called correctly."""
        # Mock environment variables
        with patch.dict(os.environ, {"PROJECT_ID": "test-project", "REGION": "us-central1"}):
            deployment.deploy.deploy_agent()
            mock_aiplatform_init.assert_called_once_with(project="test-project", location="us-central1")

    @patch('deployment.deploy.aiplatform.init')
    def test_deploy_agent_output(self, mock_aiplatform_init):
        """Tests the output messages of the deploy_agent function."""
        mock_stdout = MagicMock()
        with patch('builtins.print', mock_stdout):
            with patch.dict(os.environ, {"PROJECT_ID": "test-project", "REGION": "us-central1"}):
                deployment.deploy.deploy_agent()
        
        # Check if expected messages are printed (simulated output)
        mock_stdout.assert_any_call("Initialized Vertex AI for project: test-project in region: us-central1")
        mock_stdout.assert_any_call("Deployment complete (simulated).")

    @patch('deployment.deploy.aiplatform.init')
    def test_deploy_agent_missing_env_vars(self, mock_aiplatform_init):
        """Tests that the function raises an error if environment variables are missing."""
        with patch.dict(os.environ, {{}}, clear=True):
            with self.assertRaises(ValueError):
                deployment.deploy.deploy_agent()

if __name__ == '__main__':
    unittest.main()
