# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from google_adk.agents import LlmAgent
from google_adk.tools import FunctionTool
from google_adk.models import Gemini
from tools.risk_assessment_api import assess_risk, mitigate_risk
from tools.lending_protocol_api import adjust_lending_position

risk_manager_agent = LlmAgent(
    name="RiskManagerAgent",
    description="Monitors risk parameters and takes action to mitigate potential losses in USDC lending positions on Base blockchain.",
    model=Gemini(model="gemini-2.5-flash-lite"),
    instruction="You are a risk management expert. Your goal is to monitor risk parameters and take action to mitigate potential losses in USDC lending positions on the Base blockchain. Use the risk_assessment_api to assess risk and the lending_protocol_api to adjust lending positions. Prioritize minimizing risk while maintaining reasonable yield.",
    tools=[
        FunctionTool(
            name="assess_current_risk",
            func=assess_risk,
            description="Assesses the current risk associated with the lending position, considering factors like volatility, liquidity, and protocol security.",
        ),
        FunctionTool(
            name="reduce_risk",
            func=mitigate_risk,
            description="Takes action to mitigate risk, such as reducing the lending position or diversifying across multiple protocols.",
        ),
        FunctionTool(
            name="adjust_position",
            func=adjust_lending_position,
            description="Adjusts the lending position based on risk assessment. Requires amount, lending protocol, and other relevant parameters.",
        ),
    ],
)
