# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from google_adk.agents import LlmAgent
from google_adk.tools import FunctionTool
from google_adk.models import Gemini
from tools.lending_protocol_api import enter_lending_position, get_current_position
from utils.helper_functions import validate_address

lending_agent = LlmAgent(
    name="LendingAgent",
    description="Enters and manages USDC lending positions on the Base blockchain using lending protocols.",
    model=Gemini(model="gemini-2.5-flash-lite"),
    instruction="You are a lending expert. Your goal is to enter and manage USDC lending positions on the Base blockchain. Use the lending_protocol_api tool to interact with lending protocols. Ensure positions are entered safely and efficiently. Validate addresses before use.",
    tools=[
        FunctionTool(
            name="enter_initial_position",
            func=enter_lending_position,
            description="Enters an initial USDC lending position on the Base blockchain. Requires amount, lending protocol, and other relevant parameters.",
        ),
        FunctionTool(
            name="get_current_position_details",
            func=get_current_position,
            description="Retrieves the current details of the lending position.",
        ),
    ],
)
