# Multi-Agent System for USDC Loop Lending on Base Blockchain

This project implements a multi-agent system to automatically enter and maximize yields on USDC loop lending positions on the Base blockchain. It aims to minimize human input, ensure security and robustness, and maintain compliance with relevant regulations.

## Agents

*   **Orchestrator Agent:** Manages the overall workflow and coordinates other agents.
*   **Lending Agent:** Enters and manages lending positions on the Base blockchain.
*   **Yield Optimizer Agent:** Analyzes market conditions and adjusts lending strategies to maximize yields.
*   **Risk Manager Agent:** Monitors risk parameters and takes action to mitigate potential losses.

## Tools

*   **Blockchain API:** Provides access to the Base blockchain.
*   **Lending Protocol API:** Interacts with specific lending protocols on the Base blockchain.
*   **Risk Assessment API:** Assesses the risk associated with lending positions.

## Deployment

The `deployment` directory contains scripts for deploying the multi-agent system.

## Tests

The `tests` directory contains unit and integration tests for the agents and tools.

## Utils

The `utils` directory contains helper functions used throughout the project.

## Setup and Deployment

### Prerequisites

*   Python 3.8+
*   Google Cloud SDK installed and authenticated (`gcloud auth application-default login`)
*   An Ethereum wallet with private key and sufficient USDC on the Base network.
*   An Infura or Alchemy API key.

### Environment Variables

Create a `.env` file in the root directory of the project with the following variables:

```
PROJECT_ID=your-gcp-project-id
REGION=your-gcp-region
INFURA_API_KEY=your-infura-api-key
PRIVATE_KEY=your-ethereum-private-key
ACCOUNT_ADDRESS=your-ethereum-account-address
```

### Installation

```bash
pip install google-adk web3 python-dotenv google-cloud-aiplatform requests
```

### Deployment

1.  **Deploy to Vertex AI:**
    ```bash
    python deployment/deploy.py
    ```

2.  **Run Tests:**
    ```bash
    python -m unittest discover tests
    ```

### Running the System

To run the multi-agent system, you would typically orchestrate the agents. For example, you could start by invoking the `orchestrator_agent`:

```python
from agents.orchestrator_agent import orchestrator_agent

if __name__ == "__main__":
    # Example instruction to the orchestrator agent
    instruction = "Start the USDC lending process on Base blockchain."
    result = orchestrator_agent.run(instruction)
    print(result)
```

**Note:** The `lending_protocol_api.py` contains placeholder contract addresses and ABIs. You must replace these with the actual addresses and ABIs for the lending protocol you intend to use on the Base network (e.g., Aave, Compound).
